<?php
include("usermgmt.conf");

// Start a session and initialize
session_start();
if (!isset($_SESSION['el_user_mngt']['updateInterval'])) {
    $_SESSION['el_user_mngt']['updateInterval'] = $updateInterval;
}
if (!isset($_SESSION['el_user_mngt']['loops'])) {
   $_SESSION['el_user_mngt']['loops'] = 0;
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="keywords" content="">
<meta name="description" content="">
<title><?php echo $confCall?> Conference</title>
<style type="text/css">
a:link {color:#0000FF;}      /* unvisited link */
a:visited {color:#0000FF;}  /* visited link */
a:hover {color:#0000FF;}  /* mouse over link */
a:active {color:#FF0000;}  /* selected link */
th,td {
    /*borders and padding to make the table readable*/
    padding:.25em;
}
tr.d0 td {
    background-color: #FFF; color: black;
}
tr.d1 td {
    background-color: #CCF; color: black;
}
th {
    /*distinguish table headers from data cells*/
    background-color: #C0C0C0; color: black;
    font-weight:bold;
    text-align:center;
}
</style>
<script language="javascript" type="text/javascript">
<!-- 
var HTTPRequest = getHTTPObject();
var updateInterval = <?php echo $_SESSION['el_user_mngt']['updateInterval'] ?>;

// Get the AJAX HTTP Object
function getHTTPObject() {
   if (window.ActiveXObject) 
       return new ActiveXObject("Microsoft.XMLHTTP");
   else if (window.XMLHttpRequest) 
       return new XMLHttpRequest();
   else {
      alert("Your browser does not support AJAX.");
      return null;
   }
}

// AJAX state change handler
function handleRequestStateChange() {
    // when readyState is 4, we are ready to read the server response
    if (HTTPRequest.readyState == 4) {
      // continue only if HTTP status is "OK"
      if (HTTPRequest.status == 200) {
        try {
          // response from the server
          handleServerResponse();
        }
        catch(e) {
          alert("Error reading the response: " + e.toString());
        }
      }
      else {
        alert("There was a problem retrieving the data:\n" + HTTPRequest.statusText);
      }
    }
}

// Call the back-end script
function mainProcess(call, action) {

    // Date is just to fake out browser caching
    var date = new Date();
    var timestamp = date.getTime();
    if (call == undefined) {
        var url = "server.php?time=" + timestamp;
    } else {
        var url = "server.php?time=" + timestamp + "&call=" + call + "&action=" + action;
    }
    
    if (HTTPRequest) {
        try {
            HTTPRequest.open("GET", url, true);
            HTTPRequest.onreadystatechange = handleRequestStateChange;
            HTTPRequest.send(null);
        }
        catch (e) {
            alert("Can't connect to server:\n" + e.toString());
        }
    }
}

// Handle response received from the back-end script
function handleServerResponse() {
    
    // Just update the div
    document.getElementById("user_list").innerHTML=HTTPRequest.responseText;
}
 
// Start and repeat every updateInterval
function startUp() {

    mainProcess();
    timerID = window.setInterval("mainProcess()", updateInterval); 
}

function testClick(call, action) {
    //alert("We have a click from: " + action);
    mainProcess(call, action);
}

function connect(callField) {
    if (isEmpty(callField)) { 
        alert("Call sign must not be empty.");
    } else {
        testClick(callField.value, "connect");
    }
}

function isEmpty(aTextField) {
   if ((aTextField.value.length==0) || (aTextField.value==null)) {
      return true;
   }
   else { return false; }
}	

function qrzLookup(callSign) {
    if (callSign.indexOf("*") != -1) {
        alert("Can't look up Conferences with QRZ");
    } else {
        callSign = callSign.replace(/-L|-R/, "");
        var url = "http://www.qrz.com/db/" + callSign;
        window.open(url, 'QRZ', 'toolbar=no,location=no,status=no,resizable=yes,scrollbars=yes,width=800,height=600');
    }
}
//-->
</script>
</head>
<body onLoad="startUp()">
<center>
<h1><?php echo $confCall;?> Conference Server User Management</h1>
</center>
<form METHOD="POST" name="connForm">
   <p>Connect a station: <input style="width:100px" type="text" name="callSign" />
   <input type='button' value="Submit" onClick="connect(document.connForm.callSign);" /></p>
</form>
<div id="user_list"></div>
<small><i>Hand coded AJAX &amp; HTML by WD6AWP.</i> With thanks to KC4YOZ and WB6YMH.</small>
</body>
</html>
