<?php
include("usermgmt.conf");
session_start();
$_SESSION['el_user_mngt']['loops']++;

// Show any command results
if (isset($_SESSION['el_user_mngt']['command_results'])) {
    $time_to_keep = strtotime("30 seconds ago");
    if ($_SESSION['el_user_mngt']['command_timestamp'] < $time_to_keep) {
        unset($_SESSION['el_user_mngt']['command_results']);
        unset($_SESSION['el_user_mngt']['command_timestamp']);
    } else {
        print $_SESSION['el_user_mngt']['command_results'];
    }
}

// Execute command if any
if (isSet($_GET['call'])) {
    $call = $_GET['call'];
    $action = $_GET['action'];
    if ($action == "disconnect") {
        $cmd  =  "$tbdcmd -s 'disconnect $call'";
        $result = `$cmd`;
        setMessage($result);
    } elseif ($action == "ban_disconnect") {
        $cmd  =  "$tbdcmd -s 'disconnect $call'";
        $result = `$cmd`;
        $cmd  = "$tbdcmd -s 'ban add $call'";
        $result .= `$cmd`;
        setMessage($result);
    } elseif ($action == "mute") {
        $cmd  =  "$tbdcmd -s 'mute $call'";
        $result = `$cmd`;
        setMessage($result);
    } elseif ($action == "mute_persist") {
        $cmd  =  "$tbdcmd -s 'mute -p $call'";
        $result = `$cmd`;
        setMessage($result);
    } elseif ($action == "monitor") {
        $cmd  =  "$tbdcmd -s 'monitor $call'";
        $result = `$cmd`;
        setMessage($result);
    } elseif ($action == "reset") {
        $cmd  =  "$tbdcmd -s 'delurk $call'";
        $result = `$cmd`;
        $cmd  = "$tbdcmd -s 'monitor disable $call'";
        $result .= `$cmd`;
        $cmd  = "$tbdcmd -s 'unmute $call'";
        $result .= `$cmd`;
        $cmd  = "$tbdcmd -s 'unmute -p $call'";
        $result .= `$cmd`;
        setMessage($result);
    } elseif ($action == "about") {
        $cmd  =  "$tbdcmd -s 'about $call'";
        $result = `$cmd`;
        setMessage($result);
    } elseif ($action == "connect") {
        $cmd  =  "$tbdcmd -s 'connect $call'";
        $result = `$cmd`;
        setMessage($result);
    }
} else {
    // Status current user list
    $users = getUsers();
    if (count($users) > 0) {
        $sort=sortTx($users);
        $users=timeStamp($users);
        writeIt($users, $sort);
    } else {
        print "<h2>No users connected.</h2>";
    }
}

/*******************************
 End of script, functions below
*********************************/

// get list of users
########## ##########
function getUsers() {
    global $tbdcmd;
    
    $tbdcmd  .= ' -s "users -c -t -v"';
    $result = `$tbdcmd`;
    #print "<pre>$result</pre>";

    // process each line
    $lines = split("\n", $result);
    $users = array();
    if (count($lines) > 0 ) {
        foreach($lines as $line) {
            
            // Parse Call sign and status
            if (preg_match("/^.+ (.+) (.*), connected/U", $line, $matches)) {
                $call = $matches[1];
                $users[$call]['status'] = $matches[2];
            } elseif (preg_match("/^.+ (.+) connected/", $line, $matches)) {
                $call = $matches[1];
                $users[$call]['status'] = "";
            } else {
                continue;
            }
            
            // Parse connected
             if (preg_match("/connected: (\d+):(\d+):(\d+)/", $line, $matches)) {
                $seconds = $matches[1]*3600 + $matches[2]*60 + $matches[3];
                $users[$call]['connected']=$seconds;
            } elseif (preg_match("/connected: (\d+)\/(\d+):(\d+):(\d+)/", $line, $matches)) {
                $seconds = $matches[1]*86400 + $matches[2]*3600 + $matches[3]*60 + $matches[4];
                $users[$call]['connected'] = $seconds;
            } else {
                $users[$call]['connected']="n/a";
            }

            // Parse last tx
            if (preg_match("/last tx: (\d+):(\d+):(\d+)/", $line, $matches)) {
                $seconds = $matches[1]*3600 + $matches[2]*60 + $matches[3];
                $users[$call]['tx']=$seconds;
            } else {
                $users[$call]['tx']="Never";
            }

            // Parse version
            if (preg_match("/ver: (.+)/", $line, $matches)) {
                $users[$call]['ver']=$matches[1];
            } else {
                $users[$call]['ver']="n/a";
            }
        }
    }
    return $users;
}

########## ##########
function sortTx($users) {

    $arr=array();
    $never_heard=array();
    
    // build an array of $call => last_heard
    foreach($users as $call => $row) {
        if ($row['tx'] === "Never") {
            $never_heard[]=$call;
        } else {
            $arr[$call]=$row['tx'];
        }
    }
    
    // Sort it
    if (count($arr) > 0) {
        asort($arr, SORT_NUMERIC);
    }
    
    // Add the never heard calls to the end
    if (count($never_heard) > 0) {
        foreach($never_heard as $call) {
            $arr[$call]="Added";
        }
    }
    return ($arr);
}

########## ##########
function timeStamp($arr) {
    foreach ($arr as $call => $row) {
        $minutes_ago = strtotime("10 minutes ago");
        $yesterday = strtotime("yesterday");

        // Convert TX elapsed seconds to actual time
        if ($row['tx'] !== "Never") {
            $actual_seconds = time()-$row['tx'];
            if (strpos($row['status'], "T") !== FALSE) {
                $arr[$call]['tx'] = "<font color=\"red\">Talking</font>";
            } else {
                if ($actual_seconds < $minutes_ago) {
                    $format = "g:i a";
                } else {
                    $format = "g:i:s a";
                }
                $arr[$call]['tx'] = date($format, $actual_seconds);
            }
        }
        
        // Convert Connected elapsed seconds to actual time
        if ($row['connected'] != "n/a") {
            $actual_seconds = time()-$row['connected'];
            if (date("z", $actual_seconds) === date("z")) {
                $format = "g:i a";
            } else {
                $format = "Y-m-d g:i a";
            }
            $arr[$call]['connected'] = date($format, $actual_seconds);

        }
    }
    return $arr;
}

########## ##########
function writeIt($arr, $sort) {
    print "<table cellspacing=1 cellpadding=2 border=0 bgcolor='lightgray'>\n";
    print "<tr><th>Call</th><th>&nbsp;Last Heard&nbsp;</th><th>&nbsp;Status&nbsp;</th><th>&nbsp;Connected&nbsp;</th><th>&nbsp;Client&nbsp;</th><th>Action</th></tr>\n";
    $i=1;
    foreach ($sort as $call => $tx) {
        $row_class = $i++ % 2 != 0 ? "class='d0'" : "class='d1'";
        
        $status = $arr[$call]['status'];
        $talking = $arr[$call]['tx'];
        $client = $arr[$call]['ver'];

        $action = "<a href='#' onClick=\"testClick('$call', 'disconnect')\">Disc</a> ";
        $action .= " | <a href='#' onClick=\"testClick('$call', 'ban_disconnect')\">Disc/Ban</a>";
        $action .= " | <a href='#' onClick=\"testClick('$call', 'mute')\">Mute</a>";
        $action .= " | <a href='#' onClick=\"testClick('$call', 'mute_persist')\">Mute Persist</a>";
        $action .= " | <a href='#' onClick=\"testClick('$call', 'monitor')\">Monitor</a>";
        $action .= " | <a href='#' onClick=\"testClick('$call', 'reset')\">Reset</a>";
        $action .= " | <a href='#' onClick=\"testClick('$call', 'about')\">About</a>";
        $action .= " | <a href=\"javascript:qrzLookup('$call');\">QRZ</a>";

        // Connection status
        $connection = array();
        if (strpos($status, "B") !== FALSE or strpos($status, "C") !== FALSE) {
            $connection[] = "Conference";
        }
        if (strpos($status, "I") !== FALSE) {
            $connection[] = "Isolated (not in conference)";
        } 
        if (strpos($status, "K") !== FALSE) {
            $connection[] = "Kicked";
        } 
        if (strpos($status, "L") !== FALSE) {
            $connection[] = "Lurker";
        } 
        if (strpos($status, "M") !== FALSE) {
            $connection[] = "Audio and Text Muted";
        } 
        if (strpos($status, "P") !== FALSE) {
            $connection[] = "Permanent";
        } 
        if (strpos($status, "R") !== FALSE) {
            $connection[] = "Monitor";
        } 
        if (strpos($status, "f") !== FALSE) {
            $connection[] = "Full Duplex";
        } 
        if (strpos($status, "t") !== FALSE) {
            $connection[] = "Text Muted";
        } 
        if (strpos($status, "m") !== FALSE) {
            $connection[] = "Muted";
        } 
        if (strpos($status, "x") !== FALSE) {
            $connection[] = "Inactive";
        } 
        
        if (count($connection) > 0) {
            $status_string = join("<br/>", $connection);
        } else {
            $status_string = "Normal";
        }
        
        // Connected time
        $connected = $arr[$call]['connected'];
        
        // Print the row
        print "<tr $row_class>
        <td>$call</td><td>$talking</td><td>$status_string</td><td>$connected</td><td>$client</td><td>$action</td></tr>\n";
    }
    print "</table>\n";
}

function setMessage($text) {
    $_SESSION['el_user_mngt']['command_results'] = $text;
    $_SESSION['el_user_mngt']['command_timestamp'] = time();
}
?>
